/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.appserver;

import com.filenet.wcm.api.Document;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.VersionSeries;
import filenet.sim.appserver.IVWSIMDocQueryStringParameters;
import filenet.sim.appserver.VWSimDocIdParser;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.server.VWCapsule;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VWSIMDocHelper
implements IVWSIMDocQueryStringParameters {
    private static Logger logger = Logger.getLogger("filenet.sim.appserver");
    private static String m_className = "VWSIMDocHelper";
    private HttpServletRequest m_request = null;
    private HttpServletResponse m_response = null;
    private String m_name = null;
    private String m_pw = null;
    private String m_docId = null;
    private VWSimDocIdParser m_docIdParser = null;
    private String m_webApp = null;
    private String m_server = null;
    private String m_serverDownloadUrl = null;
    private String m_serverUploadUrl = null;
    private IVWIDMFactory m_factory = null;
    private boolean m_credsOK = false;
    Session m_session = null;
    ObjectStore m_objectStore = null;

    public VWSIMDocHelper(HttpServletRequest request, HttpServletResponse response) {
        this.m_request = request;
        this.m_response = response;
    }

    public VWSIMDocHelper(HttpServletRequest request, HttpServletResponse response, String name, String pw) {
        this.m_request = request;
        this.m_response = response;
        this.m_name = name;
        this.m_pw = pw;
        this.m_credsOK = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        String m_method = "process";
        String op = this.m_request.getParameter("op");
        if (op == null) {
            VWSIMDocHelper.replyMsg(this.m_response, "<br>Need to have an operation!</br>");
            return;
        }
        this.m_webApp = this.m_request.getParameter("webApp");
        this.m_server = this.m_request.getParameter("serverURL");
        if (!this.m_credsOK) {
            this.m_name = this.m_request.getParameter("name");
            if (this.m_name != null && this.m_name.equals("null") || this.m_name.trim().length() == 0) {
                this.m_name = null;
            }
        }
        if (!this.m_credsOK) {
            this.m_pw = this.m_request.getParameter("sess");
        }
        this.m_docId = this.m_request.getParameter("docId");
        String noenc = this.m_request.getParameter("noenc");
        boolean bl = this.m_credsOK = this.m_credsOK || noenc != null;
        if (this.m_pw == null) {
            this.m_pw = "";
        }
        logger.info(m_className, m_method, VWSIMDocHelper.dumpParameters(this.m_request));
        if (this.m_docId == null || this.m_server == null || this.m_name == null || this.m_webApp == null) {
            VWSIMDocHelper.replyMsg(this.m_response, "<br>Not enough info is given for " + op + "</br>");
            return;
        }
        this.m_serverDownloadUrl = this.m_request.getParameter("downloadURL");
        this.m_serverUploadUrl = this.m_request.getParameter("uploadURL");
        try {
            if (!this.m_credsOK) {
                VWCapsule cap1 = new VWCapsule();
                cap1.setString(this.m_name);
                this.m_name = cap1.getString();
                VWCapsule cap2 = new VWCapsule();
                cap2.setString(this.m_pw);
                this.m_pw = cap2.getString();
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "decoded name=" + this.m_name + ", pw=" + this.m_pw);
                }
            }
            this.m_docId = URLDecoder.decode(this.m_docId);
            this.m_docIdParser = new VWSimDocIdParser(this.m_docId);
            logger.info(m_className, m_method, "op=" + op + ",name=" + this.m_name + ",docId=" + this.m_docIdParser.getVersion() + ", libId=" + this.m_docIdParser.getLibrary());
            if (op.equalsIgnoreCase("updateDocStatus")) {
                String value = this.m_request.getParameter("value");
                if (value != null) {
                    this.updateDocStatus(value);
                }
                return;
            }
            if (op.equalsIgnoreCase("deleteDoc")) {
                this.deleteDoc();
                return;
            }
        }
        catch (Throwable t) {
            VWSIMDocHelper.reportException(this.m_response, "VWSIMDocHelper.process", t);
            return;
        }
        finally {
            if (this.m_factory != null) {
                this.m_factory.release();
            }
            this.m_factory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void replyMsg(HttpServletResponse response, String msg) {
        response.setContentType("text/html");
        PrintWriter out = null;
        try {
            out = response.getWriter();
            out.println("<html><head><title>VWSOAPSIM SERVLET</title></head>");
            out.println("<body><h1>VWSOAPSIMSERVLET</h1>");
            out.println("FILENET P8 BPM RESPONDED OK");
            out.println("<p>");
            out.println(msg);
            out.println("</p></body></html>");
            if (logger.isFinest()) {
                logger.finest(m_className, "replyMsg", "Responding with >>" + msg + "<<");
            }
        }
        catch (Exception e) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                    out = null;
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void reportException(HttpServletResponse response, String msg, Throwable t) {
        response.setContentType("text/html");
        PrintWriter out = null;
        try {
            out = response.getWriter();
            out.println("<html><head><title>VWSOAPSIM SERVLET</title></head>");
            out.println("<body><h1>VWSOAPSIMSERVLET</h1>");
            out.println("<p>");
            out.println(msg);
            out.println("</p><br><b>Exception:</b></br><p>");
            t.printStackTrace(out);
            logger.throwing(m_className, "reportException:" + msg, t);
        }
        catch (Exception e) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                    out = null;
                }
                catch (Exception ex) {}
            }
        }
    }

    private Document getDocument() throws Exception {
        String m_method = "getDocument";
        logger.entering(m_className, m_method);
        try {
            if (this.m_docIdParser.getLibraryType() != 3 || this.m_docIdParser.getLibrary() == null || this.m_docIdParser.getId() == null) {
                throw new VWException("VWSIMDocHelper.invalidParams", "Invalid parameters");
            }
            logger.info(m_className, m_method, "Getting Session");
            this.m_session = ObjectFactory.getSession((String)"eProcess", (String)"Clear", (String)this.m_name, (String)this.m_pw);
            this.m_session.setRemoteServerUrl(this.m_server);
            this.m_session.setRemoteServerUploadUrl(this.m_serverUploadUrl);
            this.m_session.setRemoteServerDownloadUrl(this.m_serverDownloadUrl);
            logger.info(m_className, m_method, "Getting Object Store");
            this.m_objectStore = ObjectFactory.getObjectStore((String)this.m_docIdParser.getLibrary(), (Session)this.m_session);
            String version = this.m_docIdParser.getVersion();
            if (version != null && !version.startsWith("-1")) {
                logger.info(m_className, m_method, "Getting a specific version=" + version);
                Document document = (Document)this.m_objectStore.getObject(1, version);
                return document;
            }
            logger.info(m_className, m_method, "Getting version series.");
            VersionSeries verSeries = (VersionSeries)this.m_objectStore.getObject(1140, this.m_docIdParser.getId());
            if (version == null) {
                logger.info(m_className, m_method, "Getting current version");
                Document document = verSeries.getCurrentVersion();
                return document;
            }
            logger.info(m_className, m_method, "Getting released version");
            Document document = verSeries.getReleasedVersion();
            return document;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw e;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    private void deleteDoc() throws Exception {
        String m_method = "deleteDoc";
        logger.entering(m_className, m_method);
        Document doc = this.getDocument();
        logger.info(m_className, m_method, "Retrieved the document, name= " + doc.getName());
        doc.delete();
        StringBuffer buf = new StringBuffer();
        buf.append("<br>Deleted ").append(this.m_docId).append("</br>");
        VWSIMDocHelper.replyMsg(this.m_response, buf.toString());
        logger.exiting(m_className, m_method);
    }

    private void updateDocStatus(String value) throws Exception {
        String m_method = "updateDocStatus";
        logger.entering(m_className, m_method);
        logger.info(m_className, m_method, "Setting value=" + value);
        Document doc = this.getDocument();
        logger.info(m_className, m_method, "Retrieved the document, name= " + doc.getName());
        Properties props = ObjectFactory.getProperties();
        Property prop = ObjectFactory.getProperty((String)"SimulationStatus");
        prop.setValue(value);
        props.add((Object)prop);
        logger.info(m_className, m_method, "About to setProperties..");
        doc.setProperties(props);
        StringBuffer buf = new StringBuffer();
        buf.append("<br>Updated Doc Status of ").append(this.m_docId).append("=").append(value).append("</br>");
        VWSIMDocHelper.replyMsg(this.m_response, buf.toString());
        logger.exiting(m_className, m_method);
    }

    protected static String dumpParameters(HttpServletRequest request) {
        StringBuffer buf = new StringBuffer();
        buf.append("Parameters=");
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            buf.append("<br>").append(name).append("=").append(request.getParameter(name)).append("</br>");
        }
        return buf.toString();
    }

    protected static void dumpRequestParameters(HttpServletRequest request, HttpServletResponse response) {
        VWSIMDocHelper.replyMsg(response, VWSIMDocHelper.dumpParameters(request));
    }
}

